****************************************************************************************************************
* Program: exithealutil.do
* Written By: Shani Schechter,  Aug 2011
*
*   This program computes the number of nights spent in a nursing home, for people who died since the last wave
*
*   ~~~~To Update This File (Add Waves)~~~~
*   1. Download the Preload, CoverScreen, and Health Services datasets for the new wave.
*   2. Go to the end of this file. Copy the data section for the last wave in this code and modify it for the
*   new wave (i.e. update dataset names, wave number, and variable names everywhere) with reference to the new 
*   datasets that you downloaded and the corresponding codebook. 
*   3. In the "Final Step" section, make sure "forvalues i=" includes the most recent wave # in the
*      forvalues loops.
*   
*   Inputs:  Raw exit files from Waves 2-12    (CS, PR, & E for early years; A, PR, & N for later)
*   Final Output:   C:\research\hrs\merge\exithealutil.dta  
*
****************************************************************************************************************



///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
////////////////               Preparation Stage          /////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
* First, we include 2 programs that will be called later on.

program drop _all
macro drop _all
*global saved "\\ad.ucl.ac.uk\homer\zctpmer\downloads\hrs\merge\"
global folder "D:\Dropbox"
*global folder "C:\Dropbox\"
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop"
*global saved "c:\research\hrs\merge\"
*global  saved  "C:\Users\Jeremy\Dropbox\hrs\merge\"

set seed 498742

*********************
* Getnights Program *
*********************
*This program will be run for each wave, below.
*This used to be a do-file.

*000000000000000000000000000000000000000000000000000000000000000000000
*00000000000000000000000000000000000000000000000000  program getnights
*                                                  0000000000000000000
program getnights 
   clear
   set more off
   *log using nurhm_nights_w$wave.log, replace  /* Uncomment when adding a new wave, or changing the code */

   use `1', clear

   /* Code summary / Assumptions:
   Answers given for
   1) # days in nursing home in their final stay before death
   2) # days in nursing homes overall in the last 2 years/since last interview

   We ultimately take the max of the two 
   -then topcode at the number of days between the previous interview and the date of death ("refperiod")
   -then topcode at 730 days (2yrs)  if "refperiod" is <0, ==., or >730

   For the answers:
   If report days, use as is
   If report number of months, we use Eric's imputation algorithm
      - if there are day-answers within a given month range, impute from the #days responses
      - if no day-answers in a given range, do sqrt((lowerbound+10)*upperbound)
   If report number of years, assign 365 days for answer=1 year, and 730 for answers=2 years or more

   If say continuously in nursing home since entered, calculate time between death date and entrance date
      - if missing the nursing home entrance date, take the mean response among those saying "continuous since entered"
        THEN
      - if report a nursing home entrance date that is after the death date, assign 30 days

   */

   /*
   Relevant Variables in Health Care Services module (E) or (N)
   If died at a nursing home, total length of final stay:  3 ways of reporting:
   days_bfdeath      # nights
   months_bfdeath    # months
   entermon_bfdeath  Date entered [date-month]
   enteryr_bfdeath   Date entered [date-year]
   
   Ask everyone, 
   days_total     Altogether, # of nights in a nursing home in last two years/since last interview
   months_total   Or, in months

   ***

   Relevant Variables in Cover Screen (CS) or (A)
   deathmon     Month of Death
   deathyr      Year of Death
   placedeath   Place of Death (2=in nursing home)
   nhres        Whether residing in nursinghome/healthcare facility when died
   entermon     Month moved to Nursing Home / Health Care Facility
   enteryr      Year moved to Nursing Home / Health Care Facility

   ***  

   Relevant Variables in Preload Respondent (PR_R)
   prevIWmon   Wave1 Interview Month
   prevIWyr    Interview Year
   */

   summ days_bfdeath-enteryr_bfdeath

   ********************************************
   *** Recode Don't know/refused to missing ***
   ********************************************
   recode days_bfdeath days_total entermon months_bfdeath entermon_bfdeath months_total enteryr enteryr_bfdeath deathmon deathyr  (98 99 998 999 9997 9998 9999 = .b)
   if $wave>=7 {
    recode years_bfdeath (98 99 = .b)
   }

   *Count the number of 0s
   count if days_bfdeath==0
   count if days_total==0

   *Recoding 0s to missing:
   recode days_bfdeath days_total days_bfdeath days_total entermon months_bfdeath entermon_bfdeath months_total enteryr enteryr_bfdeath deathmon deathyr prevIWmon prevIWyr (0 = .a)


   summ days_bfdeath-enteryr_bfdeath
   *Months in Nursing Home
   tab months_total, m
   tab months_bfdeath, m
   *Days in Nursing Home
   tab days_total, m
   tab days_bfdeath, m


   *****************************************************************
   * Check that different ways of reporting are mutually exclusive *
   *****************************************************************
   * Groups: days_bfdeath-entermon_bfdeath   and   days_total-months_total
   * For the following, we want no listing...

   list days_bfdeath-enteryr_bfdeath if days_bfdeath~=. & months_bfdeath~=.
   list days_bfdeath-enteryr_bfdeath if days_bfdeath~=. & entermon_bfdeath~=.
   list days_bfdeath-enteryr_bfdeath  if months_bfdeath~=. & entermon_bfdeath~=.
   list days_total months_total  if days_total~=. & months_total~=.

   *--------------------------------------------*  How About Now?  *
   list days_bfdeath-enteryr_bfdeath if days_bfdeath<. & months_bfdeath<.
   
   list days_bfdeath-enteryr_bfdeath if days_bfdeath<. & entermon_bfdeath<.
   
   list days_bfdeath-enteryr_bfdeath  if months_bfdeath<. & entermon_bfdeath<.
   
   list days_total months_total  if days_total<. & months_total<.

   if (days_bfdeath<. & months_bfdeath<.) | (days_bfdeath<. & entermon_bfdeath<.) | (months_bfdeath<. & entermon_bfdeath<.) | (days_total<. & months_total<.) {
     display "Ways of reporting not mutually exclusive. Investigate"
     
   }


   ********************************************************
   * Death Date, Last Interview Date, Nurhm Entrance Date *
   ********************************************************
   gen nurhmdate_CS=mdy(entermon,1,enteryr)
   gen deathdate=mdy(deathmon,1,deathyr) 
   gen previntvw=mdy(prevIWmon,1,1900+prevIWyr) if $wave==2
    replace previntvw=mdy(prevIWmon,1,prevIWyr) if $wave>2
   format nurhmdate_CS deathdate previntvw %td

   *When reporting nights in NurHM if died in nursing home, some people report
   *the date entered.
   gen nurhmdate_E =mdy(entermon_bfdeath,1,enteryr_bfdeath)
   format nurhmdate_E %td

   *Is this different from the date given in the cover sample (?)
   gen diff=nurhmdate_E-nurhmdate_CS
   tab diff
   drop diff

   *****************************************************
   * Ask Everyone - Total nights - if know # of nights *
   *****************************************************

   tab days_total

   *996 = continuous since entered
   * If say continuous since entered, and have date entered:
   * calculate days since entered nursing home, 

   count if days_total==996
   gen numdayscont=deathdate-nurhmdate_CS 
   replace days_total=numdayscont if days_total==996 & numdayscont>0 & numdayscont<.

   sum numdayscont if numdayscont>0 
   local mean = r(mean)
   replace days_total=floor(`mean') if days_total==996 & numdayscont>=.

   *If report dying before entered nursing home, assign 1 month in a nursing home
   replace days_total=30 if days_total==996 & numdayscont<. & numdayscont<0 


   macro drop mean
   drop numdayscont

   tab days_total


   *******************************************************
   * Ask Everyone - Total nights - just know # of months *
   *******************************************************
   tab months_total

   *Impute number of nights from number of months

   gen mmiss=.
   replace mmiss=0 if days_total>0 & days_total<996  /*donor group*/
   replace mmiss=1 if months_total<.              /*recipient group*/

   gen exactvalue=days_total
    replace exactvalue=998 if months_total<.
   gen lowervalue=((months_total-1)*30) +1
   gen uppervalue=months_total*30


   imputethis
   gen nights_sincepreviw=exactvalue
   tab nights_sincepreviw


   list HHID days_total months_total exactvalue lowervalue uppervalue nights_sincepreviw if lowervalue<., header(20) ab(20) clean
   drop exactvalue lowervalue uppervalue



   /* This next part is actually asked before the Total Days, just fyi */

   *****************************************
   * If Died in NurHM - & know # of nights *
   *****************************************
   tab days_bfdeath, m
   sum days_bfdeath
   *is 996 = continuous since entered?


   ************************************************
   * If Died in NurHM - & give Date entered Nurhm *
   ************************************************
   *Calculate number of nights from the date entered to date of death

   gen numdays=deathdate-nurhmdate_E
   replace days_bfdeath=numdays if days_bfdeath>=. & (placedeath==2 | nhres==1 | nhres==2) & numdays>0 & numdays<.

   *If report dying before entered nursing home, assign 1 month in a nursing home
   replace days_bfdeath=30 if days_bfdeath>=. & (placedeath==2 | nhres==1 | nhres==2) & numdays<0 & (nights_sincepreviw==. | nights_sincepreviw==0)

   tab days_bfdeath if numdays>0
   tab days_bfdeath, m
   drop numdays

   *****************************************
   * If Died in NurHM - & know # of months *
   *****************************************
   *Impute number of nights from number of months

   tab months_bfdeath
   gen mmiss=.
   replace mmiss=0 if days_bfdeath>0 & days_bfdeath<9000 /*donor group*/
   replace mmiss=1 if months_bfdeath<.             /*recipient group*/

   gen exactvalue=days_bfdeath
    replace exactvalue=998 if months_bfdeath<.
   gen lowervalue=((months_bfdeath-1)*30) +1
   gen uppervalue=months_bfdeath*30


   imputethis
   gen nights_bfdeath=exactvalue
   tab nights_bfdeath


   list days_bfdeath months_bfdeath exactvalue lowervalue uppervalue nights_bfdeath if lowervalue<., header(20) ab(20) clean
   drop exactvalue lowervalue uppervalue

   ****************************************
   * If Died in NurHM - & know # of years *
   ****************************************
   if $wave>=7 {
     replace nights_bfdeath=365 if years_bfdeath==1
     replace nights_bfdeath=730 if years_bfdeath>=2 & years_bfdeath<.
   }




   ****************************************************************
   * Consolidate Nights total, and nights if died in nursing home *
   ****************************************************************

   gen NHnights=max(nights_sincepreviw, nights_bfdeath) 

   *Topcode at the number of Days between the date of death and Previous Intvw 
   gen refperiod=deathdate-previntvw
   tab refperiod
   replace refperiod=30 if refperiod==0 /* If interview and death in same month (refperiod==0), don't want to topcode at 0 */
   replace NHnights=refperiod if NHnights>refperiod & refperiod>0 & NHnights<. 

   *If no deathdate or lastinvw date, or if refperiod<0 or >730 ?
   *topcode at 2 years
   *replace NHnights=730 if NHnights>730 & refperiod>=.
   replace NHnights=730 if NHnights>730 & (refperiod>=730 | refperiod<0 | refperiod==.)
 

   sum NHnights, d
   sum NHnights if NHnights>0, d
   *save nurhm_nights_w$wave, replace

   *Keep only 4 variables
   keep HHID PN NHnights
   rename NHnights dnursing$wave

   gen temp1=real(HHID)
   gen temp2=real(PN)
   
   drop HHID PN
   rename temp1 HHID
   rename temp2 PN

   *Append the datasets
   if $wave>=3 {
     append using ${saved}exithealutil
   }

   sort HHID PN
   order HHID PN dnursing*

   save ${saved}exithealutil, replace
   capture log close

end
*                                                    0000000000000
*00000000000000000000000000000000000000000000000000000000000000000
*00000000000000000000000000000000000000000000000000000000000000000



************************
* Imputation Algorithm *
************************
* This program imputes number of days when someone responds with months in nursing home

#delimit 
*0000000000000000000000000000000000000000000000000000000000000000;
*00000000000000000000000000000000000000 program define imputethis;
*                                      00000000000000000000000000;
program define imputethis;

egen recipgrp = group(lowervalue uppervalue);
tab recipgrp;
egen numgroup = max(recipgrp);
local num = numgroup[100];
display `num';
sum uppervalue;
local maxup = r(max);

gen exactvalueimpute=.;

*imputation algorithm here*****************************;

local ii =1;
while `ii' <= `num' {;

*first get upper and lower bounds ;
gen mygroup=1;
 qui replace mygroup=0 if recipgrp == `ii';

sum recipgrp if recipgrp == `ii';

sort mygroup;

local mymin= lowervalue[1];
local mymax= uppervalue[1];

qui sum exactvalue if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;
local max = r(N); * number of "donors";

qui sum exactvalue if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
local max2 = r(N); *number of "recipients" (+donors);

gen sortflag = 1;
 qui replace sortflag = 0 if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
gen sortflag2 = 1;
 display "number of donors";
 replace sortflag2 = 0 if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;

sort sortflag sortflag2  HHID PN; 

	local i=1;
	while `i' <= `max2' {;
	  local i2 = ceil(uniform()*`max');


      if (`max'>0 & `max'<999999999) {;
	  qui replace exactvalueimpute = exactvalue[`i2'] in `i';
      };
      if (`max'<1 |  `max'>999999998) {;
	  qui replace exactvalueimpute = sqrt((lowervalue+10)*uppervalue) in `i' if uppervalue~=`maxup';
	  qui replace exactvalueimpute = lowervalue in `i' if uppervalue==`maxup';
 
      *display `max2';
      *display `max';
      *sum mygroup;
	};

      local i = `i' + 1;
	};

drop mygroup sortflag sortflag2;
local ii = `ii' + 1;
};

display "number of imputed values";
replace exactvalue=exactvalueimpute if mmiss==1;
qui replace exactvalue=0 if mmiss==.;
sort mmiss;
by mmiss: sum exactvalue;

drop mmiss recipgrp numgroup exactvalueimpute;


end;

*                                                  00000000000000;
*0000000000000000000000000000000000000000000000000000000000000000;
*0000000000000000000000000000000000000000000000000000000000000000;
#delimit cr



*///////////////////////////////////////////////////////////////////////////////////////////
*///////////////////////////////////////////////////////////////////////////////////////////
*////////////////       Actual Program Starts Here         /////////////////////////////////
*///////////////////////////////////////////////////////////////////////////////////////////
* Here we pull in all the raw data, merge files and rename variables.

*exithealutil.do*
clear
capture log close
set more off
log using ${saved}exithealutil.log, replace

*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads"
*global folder "C:\research"
*global folder "C:\Users\Jeremy\Dropbox"
*global folder "~/"




         local saved  "$folder\hrs\merge\"
         local trackd "$folder\hrs\tracker\"
         local wave1d "$folder\hrs\wave1\"
         local wave2d "$folder\hrs\wave2\"
         local wave3d "$folder\hrs\wave3\"
         local wave4d "$folder\hrs\wave4\"
         local wave5d "$folder\hrs\wave5\"
		 local wave6d "$folder\hrs\wave6\"
         local wave7d "$folder\hrs\wave7\"
         local wave8d "$folder\hrs\wave8\"
		 local wave9d "$folder\hrs\wave9\"
		 local wave10d "$folder\hrs\wave10\"
		 local wave11d "$folder\hrs\wave11\"
		 local wave12d "$folder\hrs\wave12\"
		 local wave13d "$folder\hrs\wave13\"	
 		 local wave14d "$folder\hrs\wave14\"
		 local wave15d "$folder\hrs\wave15\"
         local aheadw1 "$folder\hrs\aheadw1\"
         local aheadw2 "$folder\hrs\aheadw2\"
		 



**********************
* ahead wave2 - 1995 *
**********************

*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `aheadw2'x95CS_R, clear
sort HHID PN
keep HHID PN N223 N225 N417 N418 N226 N249
tempfile deathnurhm
save `deathnurhm', replace

*Contains Last Interview Date
use `aheadw2'x95PR_R, clear
sort HHID PN
keep HHID PN N95 N96
tempfile intvwdate
save `intvwdate', replace

*Contains Data on Health Care Services
use `aheadw2'x95E_R, clear
sort HHID PN
keep HHID PN N1674-N1678 N1683 N1684

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename N95   prevIWmon 
rename N96   prevIWyr
rename N223  deathmon
rename N225  deathyr
rename N417  entermon
rename N418  enteryr
rename N226  placedeath
rename N249  nhres
rename N1674 days_bfdeath
rename N1675 months_bfdeath
rename N1676 entermon_bfdeath
rename N1678 enteryr_bfdeath
rename N1683 days_total
rename N1684 months_total


tempfile wave2_raw
save `wave2_raw', replace
des


*****************
* wave 3 - 1996 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave3d'x96CS_R, clear
sort HHID PN
keep HHID PN P223 P225 P417 P418 P226 P249
save `deathnurhm', replace

*Contains Last Interview Date
use `wave3d'x96PR_R, clear
sort HHID PN
keep HHID PN P95 P96
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave3d'x96E_R, clear
sort HHID PN
keep HHID PN P1255-P1259 P1264 P1265

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename P95   prevIWmon
rename P96   prevIWyr
rename P223  deathmon
rename P225  deathyr
rename P417  entermon
rename P418  enteryr
rename P226  placedeath
rename P249  nhres
rename P1255 days_bfdeath
rename P1256 months_bfdeath
rename P1257 entermon_bfdeath
rename P1259 enteryr_bfdeath
rename P1264 days_total
rename P1265 months_total


tempfile wave3_raw
save `wave3_raw', replace
des


*****************
* wave 4 - 1998 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave4d'x98CS_R, clear
sort HHID PN
keep HHID PN Q488 Q490 Q720 Q721 Q491 Q519
save `deathnurhm', replace

*Contains Last Interview Date
use `wave4d'x98PR_R, clear
sort HHID PN
keep HHID PN Q218 Q219
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave4d'x98E_R, clear
sort HHID PN
keep HHID PN Q1736-Q1740 Q1745 Q1746

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename Q218  prevIWmon
rename Q219  prevIWyr
rename Q488  deathmon
rename Q490  deathyr
rename Q720  entermon
rename Q721  enteryr
rename Q491  placedeath
rename Q519  nhres
rename Q1736 days_bfdeath
rename Q1737 months_bfdeath
rename Q1738 entermon_bfdeath
rename Q1740 enteryr_bfdeath
rename Q1745 days_total
rename Q1746 months_total


tempfile wave4_raw
save `wave4_raw', replace
des


*****************
* wave 5 - 2000 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave5d'x00CS_R, clear
sort HHID PN
keep HHID PN R520 R522 R789 R790 R525 R558
save `deathnurhm', replace

*Contains Last Interview Date
use `wave5d'x00PR_R, clear
sort HHID PN
keep HHID PN R218 R219
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave5d'x00E_R, clear
sort HHID PN
keep HHID PN R1747-R1751 R1756 R1757

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename R218  prevIWmon
rename R219  prevIWyr
rename R520  deathmon
rename R522  deathyr
rename R789  entermon
rename R790  enteryr
rename R525  placedeath
rename R558  nhres
rename R1747 days_bfdeath
rename R1748 months_bfdeath
rename R1749 entermon_bfdeath
rename R1751 enteryr_bfdeath
rename R1756 days_total
rename R1757 months_total


tempfile wave5_raw
save `wave5_raw', replace
des


*****************
* wave 6 - 2002 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave6d'x02A_R, clear
sort HHID PN
keep HHID PN SA121 SA123 SA065 SA066 SA124 SA028
save `deathnurhm', replace

*Contains Last Interview Date
use `wave6d'x02PR_R, clear
sort HHID PN
keep HHID PN SZ092 SZ093
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave6d'x02N_R, clear
sort HHID PN
keep HHID PN SN309-SN313 SN116 SN117

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN
drop if HHID=="011863" | HHID=="203802" //duplicates from wave 4


rename SZ092 prevIWmon
rename SZ093 prevIWyr
rename SA121 deathmon
rename SA123 deathyr
rename SA065 entermon
rename SA066 enteryr
rename SA124 placedeath
rename SA028 nhres
rename SN309 days_bfdeath
rename SN310 months_bfdeath
rename SN311 entermon_bfdeath
rename SN313 enteryr_bfdeath
rename SN116 days_total
rename SN117 months_total


tempfile wave6_raw
save `wave6_raw', replace
des


*****************
* wave 7 - 2004 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave7d'x04A_R, clear
sort HHID PN
keep HHID PN TA121 TA123 TA065 TA066 TA124 TA167
save `deathnurhm', replace

*Contains Last Interview Date
use `wave7d'x04PR_R, clear
sort HHID PN
keep HHID PN TZ092 TZ093
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave7d'x04N_R, clear
sort HHID PN
keep HHID PN TN309 TN310 TN259 TN258 TN116 TN117 TN257

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename TZ092 prevIWmon
rename TZ093 prevIWyr
rename TA121 deathmon
rename TA123 deathyr
rename TA065 entermon
rename TA066 enteryr
rename TA124 placedeath
rename TA167 nhres
rename TN309 days_bfdeath
rename TN310 months_bfdeath
rename TN257 years_bfdeath
rename TN259 entermon_bfdeath
rename TN258 enteryr_bfdeath
rename TN116 days_total
rename TN117 months_total

tempfile wave7_raw
save `wave7_raw', replace
des


*****************
* wave 8 - 2006 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave8d'x06A_R, clear
sort HHID PN
keep HHID PN UA121 UA123 UA065 UA066 UA124 UA167
save `deathnurhm', replace

*Contains Last Interview Date
use `wave8d'x06PR_R, clear
sort HHID PN
keep HHID PN UZ092 UZ093 /*UX004 UX068*/
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave8d'x06N_R, clear
sort HHID PN
keep HHID PN UN309 UN310 UN259 UN258 UN116 UN117 UN257

*Merge
merge HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename UZ092 prevIWmon
rename UZ093 prevIWyr
rename UA121 deathmon
rename UA123 deathyr
rename UA065 entermon
rename UA066 enteryr
rename UA124 placedeath
rename UA167 nhres
rename UN309 days_bfdeath
rename UN310 months_bfdeath
rename UN257 years_bfdeath
rename UN259 entermon_bfdeath
rename UN258 enteryr_bfdeath
rename UN116 days_total
rename UN117 months_total


tempfile wave8_raw
save `wave8_raw', replace
des


*****************
* wave 9 - 2008 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave9d'x08A_R, clear
sort HHID PN
keep HHID PN VA121 VA123 VA065 VA066 VA124 VA167
save `deathnurhm', replace

*Contains Last Interview Date
use `wave9d'x08PR_R, clear
sort HHID PN
keep HHID PN VZ092 VZ093 
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave9d'x08N_R, clear
sort HHID PN
keep HHID PN VN309 VN310 VN259 VN258 VN116 VN117 VN257

*Merge
merge 1:1 HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN



rename VZ092 prevIWmon
rename VZ093 prevIWyr
rename VA121 deathmon
rename VA123 deathyr
rename VA065 entermon
rename VA066 enteryr
rename VA124 placedeath
rename VA167 nhres
rename VN309 days_bfdeath
rename VN310 months_bfdeath
rename VN257 years_bfdeath
rename VN259 entermon_bfdeath
rename VN258 enteryr_bfdeath
rename VN116 days_total
rename VN117 months_total


tempfile wave9_raw
save `wave9_raw', replace
des


*****************
* wave 10 - 2010 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave10d'x10A_R, clear
sort HHID PN
keep HHID PN WA121 WA123 WA065 WA066 WA124 WA028
tempfile deathnurhm
save `deathnurhm', replace

*Contains Last Interview Date
use `wave10d'x10PR_R, clear
sort HHID PN
keep HHID PN WZ092 WZ093 
tempfile intvwdate
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave10d'x10N_R, clear
sort HHID PN
keep HHID PN WN309 WN310 WN116 WN117 WN257 //WN258 WN259

*Merge
merge 1:1 HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN

gen temp1 = WA065
gen temp2= WA066

rename WZ092 prevIWmon
rename WZ093 prevIWyr
rename WA121 deathmon
rename WA123 deathyr
rename WA065 entermon
rename WA066 enteryr
rename WA124 placedeath
rename WA028 nhres
rename WN309 days_bfdeath
rename WN310 months_bfdeath
rename WN257 years_bfdeath
rename temp1 entermon_bfdeath
rename temp2 enteryr_bfdeath
rename WN116 days_total
rename WN117 months_total

tempfile wave10_raw
save `wave10_raw', replace
des


*****************
* wave 11 - 2012 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave11d'x12A_R, clear
sort HHID PN
keep HHID PN XA121 XA123 XA065 XA066 XA124 XA028
tempfile deathnurhm
save `deathnurhm', replace

*Contains Last Interview Date
use `wave11d'x12PR_R, clear
sort HHID PN
keep HHID PN XZ092 XZ093 
tempfile intvwdate
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave11d'x12N_R, clear
sort HHID PN
keep HHID PN XN309 XN310 XN116 XN117 XN257 //XN258 XN259

*Merge
merge 1:1 HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN

gen temp1 = XA065
gen temp2= XA066

rename XZ092 prevIWmon
rename XZ093 prevIWyr
rename XA121 deathmon
rename XA123 deathyr
rename XA065 entermon
rename XA066 enteryr
rename XA124 placedeath
rename XA028 nhres
rename XN309 days_bfdeath
rename XN310 months_bfdeath
rename XN257 years_bfdeath
rename temp1 entermon_bfdeath
rename temp2 enteryr_bfdeath
rename XN116 days_total
rename XN117 months_total
tempfile wave11_raw
save `wave11_raw', replace
*des



*clear

*****************
* wave 12 - 2014 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave12d'x14A_R, clear
sort HHID PN
keep HHID PN YA121 YA123 YA065 YA066 YA124 YA028
tempfile deathnurhm
save `deathnurhm', replace

*Contains Last Interview Date
use `wave12d'x14PR_R, clear
sort HHID PN
keep HHID PN YZ092 YZ093 
tempfile intvwdate
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave12d'x14N_R, clear
sort HHID PN
keep HHID PN YN309 YN310 YN116 YN117 YN257 //YN258 YN259

*Merge
merge 1:1 HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN

gen temp1 = YA065
gen temp2= YA066

rename YZ092 prevIWmon
rename YZ093 prevIWyr
rename YA121 deathmon
rename YA123 deathyr
rename YA065 entermon
rename YA066 enteryr
rename YA124 placedeath
rename YA028 nhres
rename YN309 days_bfdeath
rename YN310 months_bfdeath
rename YN257 years_bfdeath
rename temp1 entermon_bfdeath
rename temp2 enteryr_bfdeath
rename YN116 days_total
rename YN117 months_total

tempfile wave12_raw
save `wave12_raw', replace
*des



*clear

*****************
* wave 13 - 2016 *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave13d'x16A_R, clear
sort HHID PN
keep HHID PN ZA121 ZA123 ZA065 ZA066 ZA124 ZA028
tempfile deathnurhm
save `deathnurhm', replace

*Contains Last Interview Date
use `wave13d'x16PR_R, clear
sort HHID PN
keep HHID PN ZZ092 ZZ093 
tempfile intvwdate
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave13d'x16N_R, clear
sort HHID PN
keep HHID PN ZN309 ZN310 ZN116 ZN117 ZN257 //ZN258 ZN259

*Merge
merge 1:1 HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN

gen temp1 = ZA065
gen temp2 = ZA066

rename ZZ092 prevIWmon
rename ZZ093 prevIWyr
rename ZA121 deathmon
rename ZA123 deathyr
rename ZA065 entermon
rename ZA066 enteryr
rename ZA124 placedeath
rename ZA028 nhres
rename ZN309 days_bfdeath
rename ZN310 months_bfdeath
rename ZN257 years_bfdeath
rename temp1 entermon_bfdeath
rename temp2 enteryr_bfdeath
rename ZN116 days_total
rename ZN117 months_total

tempfile wave13_raw
save `wave13_raw', replace
*des


clear



*****************
* wave 14 - 2018 *
* added by Chris *
*****************
*Contains Date of Death, Date moved into nursing home, Whether died in NurHM
use `wave14d'x18A_R, clear
sort HHID PN
keep HHID PN XQA121 XQA123 XQA065 XQA066 XQA124 XQA028
tempfile deathnurhm
save `deathnurhm', replace

*Contains Last Interview Date
use `wave14d'x18PR_R, clear
sort HHID PN
keep HHID PN XQZ092 XQZ093 
tempfile intvwdate
save `intvwdate', replace

*Contains Data on Health Care Services
use `wave14d'x18N_R, clear
sort HHID PN
keep HHID PN XQN309 XQN310 XQN116 XQN117 XQN257 //XQN258 XQN259

*Merge
merge 1:1 HHID PN using `deathnurhm'
tab _merge
drop _merge
sort HHID PN
merge HHID PN using `intvwdate'
tab _merge 
drop _merge
sort HHID PN

gen temp1 = XQA065
gen temp2 = XQA066

rename XQZ092 prevIWmon
rename XQZ093 prevIWyr
rename XQA121 deathmon
rename XQA123 deathyr
rename XQA065 entermon
rename XQA066 enteryr
rename XQA124 placedeath
rename XQA028 nhres
rename XQN309 days_bfdeath
rename XQN310 months_bfdeath
rename XQN257 years_bfdeath
rename temp1 entermon_bfdeath
rename temp2 enteryr_bfdeath
rename XQN116 days_total
rename XQN117 months_total

tempfile wave14_raw
save `wave14_raw', replace
*des


clear






*cap log close
*clear


*///////////////////////////////////////////////////////////////////////////////////////////
*///////////////////////////////////////////////////////////////////////////////////////////
*////////////////                Final Step                /////////////////////////////////
*///////////////////////////////////////////////////////////////////////////////////////////

forvalues i=2/14 {
  global wave `i'
  getnights `wave`i'_raw'
}
sleep 1000
save `saved'exithealutil, replace


* compare summary stats before and after
cd "$folder\hrs\merge\compare\" 
summtab, contvars(_all) mean median range excel excelname(exithealutil.xlsx) replace
cd "$folder\hrs\merge\" 
use exithealutil.old.dta , clear
cd "$folder\hrs\merge\compare\" 
summtab, contvars(_all) mean median range excel excelname(exithealutil.xlsx) sheetname(Old)



